### SAXS curve comparison

library (tidyverse)
library (patchwork)
library(readxl)

setwd("C:/Users/Vincent/OneDrive/Documents/csv SAXS Dataset/500")

col_list <- c("#acacac", "#36628B", "#448B74", "#A63A2E")

Tris <- read_csv("Tris.csv")
Trehalose <- read_csv("Trehalose.csv")
Sucrose <- read_csv("Sucrose.csv")
Betaine <- read_csv("Betaine.csv")

Tris_adjusted = Tris
Tris_adjusted$`I(Q)` = Tris_adjusted$`I(Q)` - Tris$`I(Q)`
Trehalose_adjusted = Trehalose
Trehalose_adjusted$`I(Q)` = Trehalose_adjusted$`I(Q)` - Tris$`I(Q)`
Sucrose_adjusted = Sucrose
Sucrose_adjusted$`I(Q)` = Sucrose_adjusted$`I(Q)` - Tris$`I(Q)`
Betaine_adjusted = Betaine
Betaine_adjusted$`I(Q)` = Betaine_adjusted$`I(Q)` - Tris$`I(Q)`

Full <- ggplot() +
  geom_line(data = Tris, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[1], size = 1) +
  geom_line(data = Trehalose, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[2], size = 1) +
  geom_line(data = Sucrose, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[3], size = 1) +
  geom_line(data = Betaine, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[4], size = 1) +
  theme_bw()+
  theme(
    plot.title = element_text(hjust = 0.1, size = 10, vjust = -11),
    axis.title = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    axis.text.x = element_text(size = 12),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1)) +
  labs(x = expression('q' * ' ' * (Å ^ -1)), y = 'ln(I(q))', title = '') +
  xlim(0.015, 0.41) +
  ylim (-2.5, 5)

Full

Full <- ggplot() +
  geom_line(data = Tris, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[1], size = 1) +
  geom_line(data = Trehalose, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[2], size = 1) +
  geom_line(data = Sucrose, aes(x = (`Q`), y = log(`I(Q)`)), color = col_list[3], size = 1) +
  theme_bw()+
  theme(
    plot.title = element_text(hjust = 0.1, size = 10, vjust = -11),
    axis.title = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    axis.text.x = element_text(size = 12),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1)) +
  labs(x = expression('q' * ' ' * (Å ^ -1)), y = 'ln(I(q))', title = '') +
  xlim(0.015, 0.41) +
  ylim (-2.5, 5)

Full

Full <- ggplot() +
  geom_line(data = Trehalose_adjusted, aes(x = (`Q`), y = `I(Q)`), color = col_list[2], size = 1) +
  geom_line(data = Sucrose_adjusted, aes(x = (`Q`), y = `I(Q)`), color = col_list[3], size = 1) +
  geom_line(data = Betaine_adjusted, aes(x = (`Q`), y = `I(Q)`), color = col_list[4], size = 1) +
  theme_bw()+
  theme(
    plot.title = element_text(hjust = 0.1, size = 10, vjust = -11),
    axis.title = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    axis.text.x = element_text(size = 12),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1)) +
  labs(x = expression('q' * ' ' * (Å ^ -1)), y = 'I(q)', title = '') +
  xlim(0.015, 0.41) +
  ylim (-5, 50)

Full

Guinier <- ggplot() +
  geom_line(data = Tris, aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[1], size = 1) +
  geom_line(data = Trehalose, aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[2], size = 1) +
  geom_line(data = Sucrose, aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[3], size = 1) +
  geom_line(data = Betaine, aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[4], size = 1) +
  theme_bw()+
  theme(
    plot.title = element_text(hjust = 0.1, size = 10, vjust = -11),
    axis.title = element_text(size = 12),
    axis.text.y = element_text(size = 12),
    axis.text.x = element_text(size = 12),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    panel.border = element_rect(colour = "black", fill=NA, size=1)) +
  labs(x = expression('q' * ' ' * (Å ^ -1)), y = 'ln(I(q))', title = '') +
  xlim(0, 0.0015) +
  ylim (0, 5)

Guinier


### E_Betaine control


setwd("~/Documents")

#call packages
library(dplyr)
library(tidyverse)
library(ggplot2)
library(readxl)
library(ggsci)
library(reshape2)
library(drc)
library(scales)
library(patchwork)
library(wesanderson)

data <-read_xlsx('Betaine_Control_Review.xlsx')
Betaine_Control <-ggplot(data = data, aes(x = Seconds, y = Abs, color = Sample))+
  geom_point(size = .5)+
  theme_bw()+
  theme(
    plot.title = element_text(hjust = 0.5, size = 6),
    axis.title = element_text(size =6),
    axis.text.y = element_text(size =6),
    axis.text.x = element_text(size =6),
    legend.text=element_text(size=14),
    legend.position = 'none', aspect.ratio = 1,
    legend.title = element_blank(),
    plot.background = element_blank(),
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    panel.border = element_blank())+
  theme(axis.line = element_line(color = 'black'))+
  labs(x = 'Time (seconds)', y = 'Absorbance (340 nm)')+
  scale_color_manual(values = c('#8B0000','grey'))
Betaine_Control + plot_layout(ncol = 4)


### Folding Correlation

library(tidyverse)
library(readxl)
library(ggpmisc)
setwd("C:/Users/Vincent/OneDrive/Documents/Boothby Lab Work/Team CAHSD/Oligomerization Project")

prot_list <- c("BSA", "AtLEA3-3", "AavLEA", "HeLEA", "AvLEA", "AtLEA4-2", "CAHS D")
cor_list <- c()
r2_list <- c()

for(i in 1:length(prot_list))
{
  protein = prot_list[i]
  
  file <- read_excel("Synergy Correlation Values.xlsx")
  file <- subset(file, Protein == protein)
  
  if(protein == "CAHS D")
  {
    cols <- c("#A63A2E", "#448B74", "#36628B")
  }else{
    cols <- c("#448B74", "#36628B")
  }
  
  file$`TFE` = file$`Adjusted dG Folding`
  file$`Metric` = file$`Synergy`
  
  plot <- ggplot(data = file) +
    geom_point(aes(x = `Metric`, y = `TFE`, fill = `Cosolute`), pch = 21, size = 4) +
    geom_smooth(method = 'lm', aes(x = `Metric`, y = `TFE`), se = F, color = "black", size = 1) +
    theme_bw()+
    theme(
      plot.title = element_text(hjust = 0.05, size = 14, vjust = -8),
      axis.title = element_text(size =14),
      axis.text.y = element_text(size =10),
      axis.text.x = element_text(size = 10, angle = 70, vjust = 1, hjust=1),
      legend.text=element_text(size=14),
      legend.position = 'none', aspect.ratio = 1,
      legend.title = element_blank(),
      panel.border = element_rect(colour = "black", fill=NA, size=1)) +
    scale_fill_manual(values = cols) +
    labs(x = 'Placeholder', y = 'Placeholder (Edit in Illustrator)', title = protein) +
    ylim(min(file$`TFE`) - 1, max(file$`TFE`) + 5) +
    xlim(min(file$`Metric` - 0.2), max(file$`Metric`) + 0.2)
  
  cor_list[i] <- cor.test(file$`TFE`, file$`Metric`, method = "pearson")$p.value
  reg_1 <- lm(file$`TFE` ~ file$`Metric`)
  r2_list[i] <- summary(reg_1)$r.squared
  
  print(plot)
}

### Betaine script

library (tidyverse)
library (patchwork)
library(readxl)

prot_list <- c("CAHSD + Betaine")
Full_list <- c()
Guinier_list <- c()
Kratky_list <- c()
ymax_list <- c(5)
rmarg_list <- c(0.1)

for(i in 1:length(prot_list))
{
  num = i
  protein = prot_list[i]
  setwd(paste("C:/Users/Vincent/OneDrive/Documents/csv SAXS Dataset/", protein, sep = ""))
  
  Dim_Kratky <- read_csv("Dimensionless_Kratky_(Rg).csv")
  
  vals <- read_excel("C:/Users/Vincent/OneDrive/Documents/Boothby Lab Work/Team CAHSD/Oligomerization Project/Oligomerization SAXS Detailed Guinier.xlsx")
  vals <- subset(vals, Protein == protein)
  
  file_list <- c("Tris - 4.csv", "10B - 4.csv", "100B - 4.csv", "500B - 4.csv")
  fit_list <- c("Tris Fit - 4.csv", "10B Fit - 4.csv", "100B Fit - 4.csv", "500B Fit - 4.csv")
  col_list <- c("#cccccc", "#A63A2E66", "#A63A2EAA", "#A63A2EFF")
  
  Full <- ggplot() +
    geom_line(data = read_csv(file_list[1]), aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[1], pch = 16, size = 1.0) +
    geom_line(data = read_csv(file_list[2]), aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[2], pch = 16, size = 1.0) +
    geom_line(data = read_csv(file_list[3]), aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[3], pch = 16, size = 1.0) +
    geom_line(data = read_csv(file_list[4]), aes(x = (`Q` * `Q`), y = log(`I(Q)`)), color = col_list[4], pch = 16, size = 1.0) +
    theme_bw()+
    theme(
      plot.title = element_text(hjust = 0.1, size = 10, vjust = -11),
      axis.title = element_text(size = 8),
      axis.text.y = element_text(size = 8),
      axis.text.x = element_text(size = 8),
      legend.text=element_text(size=14),
      legend.position = 'none', aspect.ratio = 1,
      legend.title = element_blank(),
      plot.margin = unit(c(0.001, 1, 0.001, 0.001), "inches"),
      panel.border = element_rect(colour = "black", fill=NA, size=1)) +
    labs(x = expression('q'^2 * ' ' * (Å ^ -1)), y = 'ln(I(q))', title = paste(protein, sep = "")) +
    ylim(-5, 8)
  
  Kratky <- ggplot() +
    geom_line(data = Dim_Kratky, aes(x = Dim_Kratky$`Tris - 4.dat_qRg`, y = Dim_Kratky$`Tris - 4.dat_(qRg)^2*I(q)/I(0)`), color = col_list[1], size = 1.0) +
    geom_line(data = Dim_Kratky, aes(x = Dim_Kratky$`10B - 4.dat_qRg`, y = Dim_Kratky$`10B - 4.dat_(qRg)^2*I(q)/I(0)`), color = col_list[2], size = 1.0) +
    geom_line(data = Dim_Kratky, aes(x = Dim_Kratky$`100B - 4.dat_qRg`, y = Dim_Kratky$`100B - 4.dat_(qRg)^2*I(q)/I(0)`), color = col_list[3], size = 1.0) +
    geom_line(data = Dim_Kratky, aes(x = Dim_Kratky$`500B - 4.dat_qRg`, y = Dim_Kratky$`500B - 4.dat_(qRg)^2*I(q)/I(0)`), color = col_list[4], size = 1.0) +
    theme_bw()+
    theme(
      plot.title = element_text(hjust = 0.05, size = 10, vjust = -8),
      axis.title = element_text(size = 8),
      axis.text.y = element_text(size = 8),
      axis.text.x = element_text(size = 8),
      legend.text=element_text(size=14),
      legend.position = 'none', aspect.ratio = 1,
      legend.title = element_blank(),
      plot.margin = unit(c(0.001, 1, 0.001, 0.001), "inches"),
      panel.border = element_rect(colour = "black", fill=NA, size=1)) +
    labs(x = expression('qRg'), y = expression('(I(q)/I(0))' * '*' *'qRg'^2), title = "") +
    ylim(-1, 8)
  
  Full_list[[i]] <- Full 
  Guinier_list[[i]] <- Guinier
  Kratky_list[[i]] <- Kratky
}

Guinier_list[[1]]

Kratky_list[[1]]

Full_list[[1]]